<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: چند مشتری به یک پروژه
Description: به شما اجازه میدهد تا از چند مشتری برای یک پروژه پشتیبانی کند.
Version: 1.0.0
Requires at least: 3.3.*
Author: Zeonic | زئونیک
*/

/**
 * Register activation hook
 */
register_activation_hook('multiple_customers', 'multiple_customers_module_activation_hook');

function multiple_customers_module_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}

/**
 * Register language files
 */
register_language_files('multiple_customers', ['multiple_customers']);

/**
 * Module information
 */
function multiple_customers_info()
{
    return [
        'name' => _l('multiple_customers'),
        'description' => _l('multiple_customers_description'),
        'author' => 'Your Name',
        'version' => '1.0.0',
        'required_version' => '3.3.*',
    ];
}

/**
 * Register menu item in setup menu
 */
hooks()->add_action('admin_init', 'multiple_customers_init_menu_items');
function multiple_customers_init_menu_items()
{
    $CI = &get_instance();
    if (is_admin()) {
        $CI->app_menu->add_sidebar_children_item('utilities', [
            'slug' => 'multiple-customers',
            'name' => _l('multiple_customers'),
            'href' => admin_url('multiple_customers'),
            'position' => 30,
        ]);
    }
}

/**
 * Hook to inject multi-customer field into project form
 */
hooks()->add_action('after_project_form_fields', 'add_multiple_customer_field');
function add_multiple_customer_field()
{
    $CI = &get_instance();
    log_message('debug', 'Multiple Customers: after_project_form_fields hook triggered at ' . date('Y-m-d H:i:s'));
    echo '<p style="color:red;font-weight:bold;">Debug: Multiple Customers after_project_form_fields hook is running</p>';
    $CI->load->model('multiple_customers_model');
    $CI->load->model('clients_model');
    $data['customers'] = $CI->clients_model->get();
    $data['selected_customer_ids'] = $CI->multiple_customers_model->get_project_customers($CI->uri->segment(4));
    log_message('debug', 'Multiple Customers: Customers loaded - ' . json_encode($data['customers']));
    $CI->load->view('multiple_customers/admin/projects/project', $data);
}

/**
 * Alternative hook for project form
 */
hooks()->add_action('project_form', 'add_multiple_customer_field_project_form');
function add_multiple_customer_field_project_form()
{
    $CI = &get_instance();
    log_message('debug', 'Multiple Customers: project_form hook triggered at ' . date('Y-m-d H:i:s'));
    echo '<p style="color:blue;font-weight:bold;">Debug: Multiple Customers project_form hook is running</p>';
    $CI->load->model('multiple_customers_model');
    $CI->load->model('clients_model');
    $data['customers'] = $CI->clients_model->get();
    $data['selected_customer_ids'] = $CI->multiple_customers_model->get_project_customers($CI->uri->segment(4));
    $CI->load->view('multiple_customers/admin/projects/project', $data);
}

/**
 * Alternative hook before project form close
 */
hooks()->add_action('before_project_form_close', 'add_multiple_customer_field_before_close');
function add_multiple_customer_field_before_close()
{
    $CI = &get_instance();
    log_message('debug', 'Multiple Customers: before_project_form_close hook triggered at ' . date('Y-m-d H:i:s'));
    echo '<p style="color:green;font-weight:bold;">Debug: Multiple Customers before_project_form_close hook is running</p>';
    $CI->load->model('multiple_customers_model');
    $CI->load->model('clients_model');
    $data['customers'] = $CI->clients_model->get();
    $data['selected_customer_ids'] = $CI->multiple_customers_model->get_project_customers($CI->uri->segment(4));
    $CI->load->view('multiple_customers/admin/projects/project', $data);
}