<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Multiple_customers_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function add_customers_to_project($project_id, $customer_ids)
    {
        $this->db->where('project_id', $project_id);
        $this->db->delete(db_prefix() . 'project_customers');

        if (!empty($customer_ids)) {
            foreach ($customer_ids as $customer_id) {
                $this->db->insert(db_prefix() . 'project_customers', [
                    'project_id' => $project_id,
                    'customer_id' => $customer_id,
                ]);
            }
        }
    }

    public function get_project_customers($project_id)
    {
        $this->db->where('project_id', $project_id);
        $result = $this->db->get(db_prefix() . 'project_customers')->result_array();
        return array_column($result, 'customer_id');
    }
}