<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Multiple_customers extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('multiple_customers_model');
        $this->load->model('projects_model');
    }

    public function index()
    {
        $data['title'] = _l('multiple_customers');
        $this->load->view('multiple_customers/manage', $data);
    }

    public function add_customers_to_project($project_id)
    {
        if (!has_permission('projects', '', 'edit')) {
            access_denied('projects');
        }

        if ($this->input->post()) {
            $customer_ids = $this->input->post('customer_ids');
            $this->multiple_customers_model->add_customers_to_project($project_id, $customer_ids);
            set_alert('success', _l('customers_added_successfully'));
            redirect(admin_url('projects/view/' . $project_id));
        }
    }
}