<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Multi_customer_project_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function save_project_customers($project_id, $customer_ids)
    {
        // Delete existing customers for the project
        $this->db->where('project_id', $project_id);
        $this->db->delete(db_prefix() . 'project_customers');

        // Insert new customers
        foreach ($customer_ids as $customer_id) {
            $this->db->insert(db_prefix() . 'project_customers', [
                'project_id' => $project_id,
                'customer_id' => $customer_id
            ]);
        }
    }

    public function get_project_customers($project_id)
    {
        $this->db->select('customer_id');
        $this->db->where('project_id', $project_id);
        $result = $this->db->get(db_prefix() . 'project_customers')->result_array();
        return array_column($result, 'customer_id');
    }

    public function get_projects_with_customers()
    {
        $this->db->select(db_prefix() . 'projects.id, ' . db_prefix() . 'projects.name, GROUP_CONCAT(' . db_prefix() . 'clients.company) as customers');
        $this->db->from(db_prefix() . 'projects');
        $this->db->join(db_prefix() . 'project_customers', db_prefix() . 'project_customers.project_id = ' . db_prefix() . 'projects.id', 'left');
        $this->db->join(db_prefix() . 'clients', db_prefix() . 'clients.userid = ' . db_prefix() . 'project_customers.customer_id', 'left');
        $this->db->group_by(db_prefix() . 'projects.id');
        return $this->db->get()->result_array();
    }
}
?>