<?php
defined('BASEPATH') or exit('No direct script access allowed');

hooks()->add_action('after_project_form_fields', 'add_multi_customer_field');

function add_multi_customer_field($project_id)
{
    $CI = &get_instance();
    $CI->load->model('multi_customer_project_model');
    $CI->load->model('clients_model');
    
    $selected_customers = $project_id ? $CI->multi_customer_project_model->get_project_customers($project_id) : [];
    $customers = $CI->clients_model->get();
    
    $CI->load->view('multi_customer_project/project_customers_form', [
        'customers' => $customers,
        'selected_customers' => $selected_customers
    ]);
}

hooks()->add_action('project_updated', 'save_multi_customer_project', 10, 2);

function save_multi_customer_project($project_id, $data)
{
    $CI = &get_instance();
    $CI->load->model('multi_customer_project_model');
    
    $customer_ids = $CI->input->post('customer_ids') ? $CI->input->post('customer_ids') : [];
    $CI->multi_customer_project_model->save_project_customers($project_id, $customer_ids);
}
?>