<?php

/*
|--------------------------------------------------------------------------
| Validation Language Lines
|--------------------------------------------------------------------------
|
| The following language lines contain the default error messages used by
| the validator class. Some of these rules have multiple versions such
| as the size rules. Feel free to tweak each of these messages here.
|
*/

return [
    'accepted'             => ':attribute mutlaka kabul edilmelidir.',
    'active_url'           => ':attribute mutlaka geçerli bir URL olmalıdır.',
    'after'                => ':attribute mutlaka :date tarihinden sonra olmalıdır.',
    'after_or_equal'       => ':attribute mutlaka :date tarihinden sonra veya aynı tarihte olmalıdır.',
    'alpha'                => ':attribute sadece harflerden oluşmalıdır.',
    'alpha_dash'           => ':attribute sadece harflerden, rakamlardan ve tirelerden oluşmalıdır.',
    'alpha_num'            => ':attribute sadece harflerden ve rakamlardan oluşmalıdır.',
    'array'                => ':attribute mutlaka bir dizi olmalıdır.',
    'attached'             => 'This :attribute is already attached.',
    'before'               => ':attribute mutlaka :date tarihinden önce olmalıdır.',
    'before_or_equal'      => ':attribute mutlaka :date tarihinden önce veya aynı tarihte olmalıdır.',
    'between'              => [
        'array'   => ':attribute mutlaka :min - :max arasında öğe içermelidir.',
        'file'    => ':attribute mutlaka :min - :max kilobayt arasında olmalıdır.',
        'numeric' => ':attribute mutlaka :min - :max arasında olmalıdır.',
        'string'  => ':attribute mutlaka :min - :max harf arasında olmalıdır.',
    ],
    'boolean'              => ':attribute sadece doğru veya yanlış olmalıdır.',
    'confirmed'            => ':attribute tekrarı eşleşmiyor.',
    'date'                 => ':attribute geçerli bir tarih değil.',
    'date_equals'          => ':attribute mutlaka :date ile aynı tarihte olmalıdır.',
    'date_format'          => ':attribute mutlaka :format biçiminde olmalıdır.',
    'different'            => ':attribute ile :other mutlaka birbirinden farklı olmalıdır.',
    'digits'               => ':attribute mutlaka :digits basamaklı olmalıdır.',
    'digits_between'       => ':attribute mutlaka en az :min, en fazla :max basamaklı olmalıdır.',
    'dimensions'           => ':attribute geçersiz resim boyutlarına sahip.',
    'distinct'             => ':attribute alanı yinelenen bir değere sahip.',
    'email'                => ':attribute mutlaka geçerli bir eposta adresi olmalıdır.',
    'ends_with'            => ':attribute sadece şu değerlerden biriyle bitebilir: :values.',
    'exists'               => 'Seçili :attribute geçersiz.',
    'file'                 => ':attribute mutlaka bir dosya olmalıdır.',
    'filled'               => ':attribute mutlaka doldurulmalıdır.',
    'gt'                   => [
        'array'   => ':attribute mutlaka :value sayısından daha fazla öğe içermelidir.',
        'file'    => ':attribute mutlaka :value kilobayttan büyük olmalıdır.',
        'numeric' => ':attribute mutlaka :value sayısından büyük olmalıdır.',
        'string'  => ':attribute mutlaka :value harften uzun olmalıdır.',
    ],
    'gte'                  => [
        'array'   => ':attribute mutlaka :value veya daha fazla öğe içermelidir.',
        'file'    => ':attribute mutlaka :value kilobayttan büyük veya eşit olmalıdır.',
        'numeric' => ':attribute mutlaka :value sayısından büyük veya eşit olmalıdır.',
        'string'  => ':attribute mutlaka :value harften uzun veya eşit olmalıdır.',
    ],
    'image'                => ':attribute mutlaka bir resim olmalıdır.',
    'in'                   => 'Seçili :attribute geçersiz.',
    'in_array'             => ':attribute :other içinde mevcut değil.',
    'integer'              => ':attribute mutlaka bir tamsayı olmalıdır.',
    'ip'                   => ':attribute mutlaka geçerli bir IP adresi olmalıdır.',
    'ipv4'                 => ':attribute mutlaka geçerli bir IPv4 adresi olmalıdır.',
    'ipv6'                 => ':attribute mutlaka geçerli bir IPv6 adresi olmalıdır.',
    'json'                 => ':attribute mutlaka geçerli bir JSON içeriği olmalıdır.',
    'lt'                   => [
        'array'   => ':attribute mutlaka :value sayısından daha az öğe içermelidir.',
        'file'    => ':attribute mutlaka :value kilobayttan küçük olmalıdır.',
        'numeric' => ':attribute mutlaka :value sayısından küçük olmalıdır.',
        'string'  => ':attribute mutlaka :value harften kısa olmalıdır.',
    ],
    'lte'                  => [
        'array'   => ':attribute mutlaka :value veya daha az öğe içermelidir.',
        'file'    => ':attribute mutlaka :value kilobayttan küçük veya eşit olmalıdır.',
        'numeric' => ':attribute mutlaka :value sayısından küçük veya eşit olmalıdır.',
        'string'  => ':attribute mutlaka :value harften kısa veya eşit olmalıdır.',
    ],
    'max'                  => [
        'array'   => ':attribute en fazla :max öğe içerebilir.',
        'file'    => ':attribute en fazla :max kilobayt olabilir.',
        'numeric' => ':attribute en fazla :max olabilir.',
        'string'  => ':attribute en fazla :max harf olabilir.',
    ],
    'mimes'                => ':attribute mutlaka :values biçiminde bir dosya olmalıdır.',
    'mimetypes'            => ':attribute mutlaka :values biçiminde bir dosya olmalıdır.',
    'min'                  => [
        'array'   => ':attribute en az :min öğe içerebilir.',
        'file'    => ':attribute en az :min kilobayt olabilir.',
        'numeric' => ':attribute en az :min olabilir.',
        'string'  => ':attribute en az :min harf olabilir.',
    ],
    'multiple_of'          => 'The :attribute must be a multiple of :value',
    'not_in'               => 'Seçili :attribute geçersiz.',
    'not_regex'            => ':attribute biçimi geçersiz.',
    'numeric'              => ':attribute mutlaka bir sayı olmalıdır.',
    'password'             => 'Parola geçersiz.',
    'present'              => ':attribute mutlaka mevcut olmalıdır.',
    'prohibited'           => ':attribute alanı kısıtlanmıştır.',
    'prohibited_if'        => ':other alanının değeri :value olduğunda :attribute alanına veri girişi yapılamaz.',
    'prohibited_unless'    => ':other alanı :value değerlerinin dışında olduğunda :attribute alanına veri girişi yapılamaz.',
    'regex'                => ':attribute biçimi geçersiz.',
    'relatable'            => 'This :attribute may not be associated with this resource.',
    'required'             => ':attribute mutlaka gereklidir.',
    'required_if'          => ':attribute :other :value değerine sahip olduğunda mutlaka gereklidir.',
    'required_unless'      => ':attribute :other :values değerlerinden birine sahip olmadığında mutlaka gereklidir.',
    'required_with'        => ':attribute :values varken mutlaka gereklidir.',
    'required_with_all'    => ':attribute herhangi bir :values değeri varken mutlaka gereklidir.',
    'required_without'     => ':attribute :values yokken mutlaka gereklidir.',
    'required_without_all' => ':attribute :values değerlerinden herhangi biri yokken mutlaka gereklidir.',
    'same'                 => ':attribute ile :other eşleşmelidir.',
    'size'                 => [
        'array'   => ':attribute mutlaka :size öğeye sahip olmalıdır.',
        'file'    => ':attribute mutlaka :size kilobayt olmalıdır.',
        'numeric' => ':attribute mutlaka :size olmalıdır.',
        'string'  => ':attribute mutlaka :size harfli olmalıdır.',
    ],
    'starts_with'          => ':attribute sadece şu değerlerden biriyle başlayabilir: :values.',
    'string'               => ':attribute mutlaka bir metin olmalıdır.',
    'timezone'             => ':attribute mutlaka geçerli bir saat dilimi olmalıdır.',
    'unique'               => ':attribute zaten alınmış.',
    'uploaded'             => ':attribute yüklemesi başarısız.',
    'url'                  => ':attribute biçimi geçersiz.',
    'uuid'                 => ':attribute mutlaka geçerli bir UUID olmalıdır.',
    'custom'               => [
        'niteleyici-adi' => [
            'kural-adi' => 'Özel doğrulama mesajı',
        ],
    ],
    'attributes'           => [
        'address'               => 'Adres',
        'age'                   => 'Yaş',
        'available'             => 'Mevcut',
        'city'                  => 'Şehir',
        'content'               => 'İçerik',
        'country'               => 'Ülke',
        'date'                  => 'Tarih',
        'day'                   => 'Gün',
        'description'           => 'Açıklama',
        'email'                 => 'E-posta adresi',
        'excerpt'               => 'Alıntı',
        'first_name'            => 'Adı',
        'gender'                => 'Cinsiyet',
        'hour'                  => 'Saat',
        'last_name'             => 'Soyadı',
        'minute'                => 'Dakika',
        'mobile'                => 'Cep telefonu',
        'month'                 => 'Ay',
        'name'                  => 'Adı',
        'password'              => 'Şifre',
        'password_confirmation' => 'Şifre (Tekrar)',
        'phone'                 => 'Telefon',
        'second'                => 'Saniye',
        'sex'                   => 'Cinsiyet',
        'size'                  => 'Boyut',
        'time'                  => 'Zaman',
        'title'                 => 'Ünvan',
        'username'              => 'Kullanıcı adı',
        'year'                  => 'Yıl',
    ],
];
