<?php $__env->startSection('pagename'); ?>
    - <?php echo e(__('Home')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta-description', !empty($seo) ? $seo->home_meta_description : ''); ?>
<?php $__env->startSection('meta-keywords', !empty($seo) ? $seo->home_meta_keywords : ''); ?>
<?php $__env->startSection('content'); ?>
    <!-- Home Start-->
    <section id="home" class="home-banner pb-80">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-10">
                    <div class="content mb-40 mx-auto text-center">
                        <span class="subtitle color-primary" data-aos="fade-up"> <?php echo e($be->hero_section_title); ?></span>
                        <h1 class="title" data-aos="fade-up" data-aos-delay="100">
                            <?php echo e($be->hero_section_subtitle); ?>

                        </h1>
                        <p data-aos="fade-up" data-aos-delay="150">
                            <?php echo e($be->hero_section_text); ?>

                        </p>
                        <div class="btn-groups justify-content-center" data-aos="fade-up" data-aos-delay="200">
                            <?php if(!empty($be->hero_section_button_url)): ?>
                                <a href="<?php echo e($be->hero_section_button_url); ?>" class="btn btn-lg btn-primary"
                                    title="<?php echo e($be->hero_section_button_text); ?>"
                                    target="_self"><?php echo e($be->hero_section_button_text); ?></a>
                            <?php endif; ?>
                            <?php if(!empty($be->hero_section_secound_button_url)): ?>
                                <a href="<?php echo e($be->hero_section_secound_button_url); ?>" class="btn btn-lg btn-outline"
                                    title="<?php echo e($be->hero_section_secound_button_text); ?>"
                                    target="_self"><?php echo e($be->hero_section_secound_button_text); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="banner-img mb-40 text-center" data-aos="fade-left">

                        <img class="lazyload"
                            data-src="<?php echo e(!empty($be->hero_img) ? asset('assets/front/img/' . $be->hero_img) : asset('assets/frontend/images/banner.png')); ?>"
                            alt="Banner Image">
                    </div>
                </div>
            </div>
        </div>
        <!-- Banner Images -->
        <div class="banner-images d-none d-lg-block">
            <img class="lazyload blur-up img-1"
                data-src="<?php echo e(!empty($be->hero_img2) ? asset('assets/front/img/' . $be->hero_img2) : asset('assets/frontend/images/banner-img-1.jpg')); ?>"
                alt="Banner Image">
            <img class="lazyload blur-up img-2"
                data-src="<?php echo e(!empty($be->hero_img3) ? asset('assets/front/img/' . $be->hero_img3) : asset('assets/frontend/images/banner-img-2.jpg')); ?>"
                alt="Banner Image">
            <img class="lazyload blur-up img-3"
                data-src="<?php echo e(!empty($be->hero_img4) ? asset('assets/front/img/' . $be->hero_img4) : asset('assets/frontend/images/banner-img-3.jpg')); ?>"
                alt="Banner Image">
            <img class="lazyload blur-up img-4"
                data-src="<?php echo e(!empty($be->hero_img5) ? asset('assets/front/img/' . $be->hero_img5) : asset('assets/frontend/images/banner-img-4.jpg')); ?>"
                alt="Banner Image">
        </div>
        <!-- Bg-shape -->
        <div class="bg-shape bg-primary-light">
            <img class="lazyload" data-src="<?php echo e(asset('assets/frontend/images/banner-bg.png')); ?>" alt="Shape">
        </div>
        <!-- Shape -->
        <div class="shape">
            <img class="lazyload shape-1" data-src="<?php echo e(asset('assets/frontend/images/shape/shape-1.png')); ?>"
                alt="Shape">
            <img class="lazyload shape-2" data-src="<?php echo e(asset('assets/frontend/images/shape/shape-2.png')); ?>"
                alt="Shape">
            <img class="lazyload shape-3" data-src="<?php echo e(asset('assets/frontend/images/shape/shape-3.png')); ?>"
                alt="Shape">
            <img class="lazyload shape-4" data-src="<?php echo e(asset('assets/frontend/images/shape/shape-4.png')); ?>"
                alt="Shape">
            <img class="lazyload shape-5" data-src="<?php echo e(asset('assets/frontend/images/shape/shape-5.png')); ?>"
                alt="Shape">
            <img class="lazyload shape-6" data-src="<?php echo e(asset('assets/frontend/images/shape/shape-6.png')); ?>"
                alt="Shape">
            <img class="lazyload shape-7" data-src="<?php echo e(asset('assets/frontend/images/shape/shape-7.png')); ?>"
                alt="Shape">
        </div>
    </section>
    <!-- Home End -->
    <?php if($bs->partners_section == 1): ?>
        <!-- Sponsor Start  -->
        <section class="sponsor">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="section-title title-center mb-50" data-aos="fade-up">
                            <span class="subtitle"><?php echo e($bs->partners_section_title); ?></span>
                            <h2 class="title"><?php echo e($bs->partners_section_subtitle); ?></h2>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="swiper sponsor-slider">
                            <div class="swiper-wrapper">
                                <?php $__currentLoopData = $partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="swiper-slide">
                                        <div class="item-single d-flex justify-content-center">
                                            <div class="sponsor-img">
                                                <img class="lazyload blur-up"
                                                    data-src="<?php echo e(asset('assets/front/img/partners/' . $partner->image)); ?>"
                                                    alt="Sponsor">
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <div class="swiper-pagination position-static mt-30" data-aos="fade-up"></div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Sponsor End -->
    <?php endif; ?>
    <?php if($bs->process_section == 1): ?>
        <!-- Store Start -->
        <section class="store-area pt-120 pb-90">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="section-title title-inline mb-50" data-aos="fade-up">
                            <h2 class="title"><?php echo e($bs->work_process_title); ?></h2>

                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row justify-content-center">
                            <?php $__currentLoopData = $processes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $process): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-sm-6 col-lg-4 col-xl-3 mb-30 item" data-aos="fade-up">
                                    <div class="card">
                                        <div class="card-icon">
                                            <?php if(!empty($process->image)): ?>
                                                <img class="lazyload"
                                                    data-src="<?php echo e(asset('assets/front/img/process/' . $process->image)); ?>"
                                                    alt="Icon">
                                            <?php endif; ?>
                                        </div>
                                        <div class="card-content">
                                            <a href="javaScript:void(0)">
                                                <h4 class="card-title  "><?php echo e($process->title); ?></h4>
                                            </a>
                                            <p class="card-text ">
                                                <?php echo e($process->subtitle); ?>

                                            </p>

                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                </div>
            </div>
            <!-- Bg Shape -->
            <div class="shape">
                <img class="shape-1" src="<?php echo e(asset('assets/frontend/images/shape/shape-3.png')); ?>" alt="Shape">
                <img class="shape-2" src="<?php echo e(asset('assets/frontend/images/shape/shape-9.png')); ?>" alt="Shape">
                <img class="shape-3" src="<?php echo e(asset('assets/frontend/images/shape/shape-6.png')); ?>" alt="Shape">
                <img class="shape-4" src="<?php echo e(asset('assets/frontend/images/shape/shape-1.png')); ?>" alt="Shape">
            </div>
        </section>
        <!-- Store End -->
    <?php endif; ?>
    <?php if($bs->templates_section == 1): ?>
        <!-- Template Start -->
        <section class="template-area bg-primary-light ptb-120">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-8 col-lg-6">
                        <div class="section-title title-center mb-50" data-aos="fade-up">
                            <span class="subtitle"><?php echo e($bs->preview_templates_title); ?></span>
                            <h2 class="title mt-0"><?php echo e($bs->preview_templates_subtitle); ?></h2>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row justify-content-center">
                            <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-4 col-sm-6" data-aos="fade-up">
                                    <div class="card text-center mb-50">
                                        <div class="card-image">
                                            <div class="lazy-container">
                                                <img class="lazyload lazy-image"
                                                    data-src="<?php echo e(asset('assets/front/img/template-previews/' . $template->template_img)); ?>"
                                                    alt="Demo Image" />
                                            </div>
                                            <div class="hover-show">
                                                <a href="<?php echo e(detailsUrl($template)); ?>" target="_blank"
                                                    class="btn-icon rounded-circle" title="View Details">
                                                    <i class="fal fa-link"></i>
                                                </a>
                                            </div>
                                        </div>
                                        <h4 class="card-title">
                                            <a href="<?php echo e(detailsUrl($template)); ?>" title="Link" target="_blank">
                                                <?php echo e(__($template->template_name)); ?>

                                            </a>
                                        </h4>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <div class="col-12 text-center">
                                <a href="<?php echo e(route('front.templates')); ?>" class="btn btn-lg btn-primary"
                                    title="<?php echo e(__('More Templates')); ?>" target="_blank"><?php echo e(__('More Templates')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Bg Shape -->
            <div class="shape">
                <img class="shape-1" src="<?php echo e(asset('assets/frontend/images/shape/shape-4.png')); ?>" alt="Shape">
                <img class="shape-2" src="<?php echo e(asset('assets/frontend/images/shape/shape-3.png')); ?>" alt="Shape">
                <img class="shape-3" src="<?php echo e(asset('assets/frontend/images/shape/shape-9.png')); ?>" alt="Shape">
                <img class="shape-4" src="<?php echo e(asset('assets/frontend/images/shape/shape-7.png')); ?>" alt="Shape">
                <img class="shape-5" src="<?php echo e(asset('assets/frontend/images/shape/shape-11.png')); ?>" alt="Shape">
                <img class="shape-6" src="<?php echo e(asset('assets/frontend/images/shape/shape-4.png')); ?>" alt="Shape">
                <img class="shape-7" src="<?php echo e(asset('assets/frontend/images/shape/shape-8.png')); ?>" alt="Shape">
                <img class="shape-8" src="<?php echo e(asset('assets/frontend/images/shape/shape-4.png')); ?>" alt="Shape">
                <img class="shape-9" src="<?php echo e(asset('assets/frontend/images/shape/shape-7.png')); ?>" alt="Shape">
                <img class="shape-10" src="<?php echo e(asset('assets/frontend/images/shape/shape-10.png')); ?>" alt="Shape">
            </div>
        </section>
        <!-- Template End -->
    <?php endif; ?>

    <?php if($bs->feature_section == 1 || $bs->intro_section == 1): ?>
        <!-- Choose Start -->
        <section class="choose-area pt-120 pb-80">
            <div class="container">
                <div class="row align-items-center">
                    <?php if($bs->intro_section == 1): ?>
                        <div class="col-lg-6">
                            <div class="content-title mb-40 pe-lg-5" data-aos="fade-right">
                                <span class="subtitle"><?php echo e($bs->intro_title); ?></span>
                                <h2 class="title"><?php echo e($bs->intro_subtitle); ?></h2>
                                <?php
                                    $contents = explode(PHP_EOL, $bs->intro_text);
                                ?>

                                <?php $__currentLoopData = $contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($loop->first): ?>
                                        <p class="text"><?php echo e($content); ?></p>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <ul class="choose-list list-unstyled p-0">
                                    <?php $__currentLoopData = $contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(!$loop->first): ?>
                                            <li class="ps-0">
                                                <?php echo e($content); ?>

                                            </li>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                                <?php if($bs->intro_button_name && $bs->intro_button_url): ?>
                                    <a href="<?php echo e($bs->intro_button_url); ?>" class="btn btn-lg btn-primary"
                                        title="Purchase Now" target="_self"><?php echo e($bs->intro_button_name); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($bs->feature_section == 1): ?>
                        <div <?php if($bs->intro_section != 1): ?> class="col-lg-12" <?php else: ?> class="col-lg-6" <?php endif; ?>>
                            <div class="row justify-content-center mb-10">
                                <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-sm-6" data-aos="fade-up">
                                        <div class="card mb-30">
                                            <div class="card-icon">
                                                <img src="<?php echo e($feature->image ? asset('assets/front/img/features/' . $feature->image) : asset('assets/frontend/images/icon/languages.png')); ?>"
                                                    alt="Icon">
                                            </div>
                                            <div class="card-content">
                                                <a href="#">
                                                    <h4 class="card-title "><?php echo e($feature->title); ?></h4>
                                                </a>
                                                <p class="card-text"><?php echo e($feature->text); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <!-- Bg Shape -->
            <div class="shape">
                <img class="shape-1" src="<?php echo e(asset('assets/frontend/images/shape/shape-6.png')); ?>" alt="Shape">
                <img class="shape-2" src="<?php echo e(asset('assets/frontend/images/shape/shape-7.png')); ?>" alt="Shape">
                <img class="shape-3" src="<?php echo e(asset('assets/frontend/images/shape/shape-3.png')); ?>" alt="Shape">
                <img class="shape-4" src="<?php echo e(asset('assets/frontend/images/shape/shape-4.png')); ?>" alt="Shape">
                <img class="shape-5" src="<?php echo e(asset('assets/frontend/images/shape/shape-5.png')); ?>" alt="Shape">
                <img class="shape-6" src="<?php echo e(asset('assets/frontend/images/shape/shape-11.png')); ?>" alt="Shape">
            </div>
        </section>
        <!-- Choose End -->
    <?php endif; ?>
    <?php if($bs->vcard_section == 1): ?>
        <!-- Vcard Start -->
        <section class="vcard-area bg-primary-light pt-120 pb-80">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="content-title mb-40 pe-lg-5" data-aos="fade-right">
                            <h2 class="title">
                                <?php echo e($bs->vcard_section_title); ?>

                            </h2>
                            <p class="text">
                                <?php echo e($bs->vcard_section_subtitle); ?>

                            </p>
                            <a href="<?php echo e(route('front.vcards')); ?>" class="btn btn-lg btn-primary"
                                title="<?php echo e(__('More Templates')); ?>" target="_self"><?php echo e(__('More Templates')); ?>

                            </a>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="swiper vcard-slider mb-40"
                            <?php if(count($vcards) < 3): ?> data-slides-per-view="2" <?php else: ?> data-slides-per-view="3" <?php endif; ?>>
                            <div class="swiper-wrapper">
                                <?php $__currentLoopData = $vcards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vcard): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="swiper-slide">
                                        <div class="card text-center">
                                            <div class="card-image">
                                                <div class="lazy-container">
                                                    <img class="lazyload lazy-image"
                                                        data-src="<?php echo e(asset('assets/front/img/template-previews/vcard/' . $vcard->template_img)); ?>"
                                                        alt="<?php echo e($vcard->vcard_name); ?>" />
                                                </div>
                                                <div class="hover-show">
                                                    <a href="<?php echo e(route('front.user.vcard', [$vcard->user->username, $vcard->id])); ?>"
                                                        target="_blank" class="btn-icon rounded-circle"
                                                        title="View Details">
                                                        <i class="fal fa-link"></i>
                                                    </a>
                                                </div>
                                            </div>
                                            <h6 class="card-title">
                                                <a href="<?php echo e(route('front.user.vcard', [$vcard->user->username, $vcard->id])); ?>"
                                                    title="Link" target="_blank">
                                                    <?php echo e(__($vcard->template_name)); ?>

                                                </a>
                                            </h6>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <!-- Slider pagination's -->
                            <div class="swiper-pagination position-static vcard-slider-pagination mt-30"></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Bg Shape -->
            <div class="shape">
                <img class="shape-1" src="<?php echo e(asset('assets/frontend/images/shape/shape-1.png')); ?>" alt="Shape">
                <img class="shape-2" src="<?php echo e(asset('assets/frontend/images/shape/shape-3.png')); ?>" alt="Shape">
                <img class="shape-3" src="<?php echo e(asset('assets/frontend/images/shape/shape-6.png')); ?>" alt="Shape">
                <img class="shape-4" src="<?php echo e(asset('assets/frontend/images/shape/shape-4.png')); ?>" alt="Shape">
                <img class="shape-5" src="<?php echo e(asset('assets/frontend/images/shape/shape-11.png')); ?>" alt="Shape">
                <img class="shape-6" src="<?php echo e(asset('assets/frontend/images/shape/shape-10.png')); ?>" alt="Shape">
            </div>
        </section>
        <!-- Vcard End -->
    <?php endif; ?>
    <?php if($bs->pricing_section == 1): ?>
        <!-- Pricing Start -->
        <section class="pricing-area pt-120 pb-90">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="section-title title-center mb-50" data-aos="fade-up">
                            <span class="subtitle"><?php echo e($bs->pricing_title); ?></span>
                            <h2 class="title mb-2 mt-0"><?php echo e($bs->pricing_subtitle); ?></h2>
                            <p class="text"><?php echo e($bs->pricing_text); ?></p>
                        </div>
                    </div>

                    <div class="col-12">
                        <?php if(count($terms) > 1): ?>
                            <div class="nav-tabs-navigation text-center" data-aos="fade-up">
                                <ul class="nav nav-tabs">
                                    <?php $__currentLoopData = $terms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $term): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item">
                                            <button class="nav-link <?php echo e($loop->first ? 'active' : ''); ?>"
                                                data-bs-toggle="tab" data-bs-target="#<?php echo e(strtolower($term)); ?>"
                                                type="button"><?php echo e(__("$term")); ?></button>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                            </div>
                        <?php endif; ?>
                        <div class="tab-content">
                            <?php $__currentLoopData = $terms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $term): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="tab-pane fade <?php echo e($loop->first ? 'active show' : ''); ?> "
                                    id="<?php echo e(strtolower($term)); ?>">
                                    <div class="row justify-content-center">
                                        <?php
                                            $packages = \App\Models\Package::where('status', '1')
                                                ->where('featured', '1')
                                                ->where('term', strtolower($term))
                                                ->orderBy('serial_number', 'ASC')
                                                ->get();
                                        ?>
                                        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $pFeatures = json_decode($package->features);
                                            ?>
                                            <div class="col-md-6 col-lg-4">
                                                <div class="card mb-30" data-aos="fade-up" data-aos-delay="100">
                                                    <div class="d-flex align-items-center mb-20">
                                                        <div class="icon"><i class="<?php echo e($package->icon); ?>"></i></div>
                                                        <div class="label">
                                                            <h4><?php echo e(__($package->title)); ?></h4>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex align-items-center">
                                                        <span class="price">
                                                            <?php echo e($package->price != 0 && $be->base_currency_symbol_position == 'left' ? $be->base_currency_symbol : ''); ?><?php echo e($package->price == 0 ? 'Free' : $package->price); ?><?php echo e($package->price != 0 && $be->base_currency_symbol_position == 'right' ? $be->base_currency_symbol : ''); ?>

                                                        </span>
                                                        <span class="period">/ <?php if($package->term == 'monthly'): ?>
                                                                <?php echo e(__('month')); ?>

                                                            <?php elseif($package->term == 'yearly'): ?>
                                                                <?php echo e(__('year')); ?>

                                                            <?php else: ?>
                                                                <?php echo e(__($package->term)); ?>

                                                            <?php endif; ?>
                                                        </span>
                                                    </div>
                                                    <h5><?php echo e(__("What's Included")); ?></h5>
                                                    <ul class="pricing-list list-unstyled p-0"
                                                        data-more="<?php echo e(__('Show More')); ?>"
                                                        data-less="<?php echo e(__('Show Less')); ?>">

                                                        <?php $__currentLoopData = $allPfeatures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li>
                                                                <?php if(is_array($pFeatures) && in_array($feature, $pFeatures)): ?>
                                                                    <i class="fal fa-check"></i>
                                                                <?php else: ?>
                                                                    <i class="fal fa-times"></i>
                                                                <?php endif; ?>

                                                                <?php if($feature == 'vCard' && is_array($pFeatures) && in_array($feature, $pFeatures)): ?>
                                                                    <?php if($package->number_of_vcards == 999999): ?>
                                                                        <?php echo e(__('Unlimited')); ?> <?php echo e(__('vCards')); ?>

                                                                    <?php elseif(empty($package->number_of_vcards)): ?>
                                                                        0 <?php echo e(__('vCard')); ?>

                                                                    <?php else: ?>
                                                                        <?php echo e($package->number_of_vcards); ?>

                                                                        <?php echo e($package->number_of_vcards > 1 ? __('vCards') : __('vCard')); ?>

                                                                    <?php endif; ?>
                                                                    <?php continue; ?>
                                                                <?php elseif($feature == 'vCard' && (is_array($pFeatures) && !in_array($feature, $pFeatures))): ?>
                                                                    <?php echo e(__('vCards')); ?>

                                                                    <?php continue; ?>
                                                                <?php endif; ?>
                                                                <?php echo e(__("$feature")); ?>

                                                                <?php if($feature == 'Plugins'): ?>
                                                                    (<?php echo e(__('Google Analytics, Disqus, WhatsApp, Facebook Pixel, Tawk.to')); ?>)
                                                                <?php endif; ?>
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                                    </ul>
                                                    <div class="btn-groups">

                                                        <?php if($package->is_trial === '1' && $package->price != 0): ?>
                                                            <a href="<?php echo e(route('front.register.view', ['status' => 'trial', 'id' => $package->id])); ?>"
                                                                class="btn btn-lg btn-primary no-animation"
                                                                target="_self"><?php echo e(__('Trial')); ?></a>
                                                        <?php endif; ?>
                                                        <?php if($package->price == 0): ?>
                                                            <a href="<?php echo e(route('front.register.view', ['status' => 'regular', 'id' => $package->id])); ?>"
                                                                target="_self"
                                                                class="btn btn-lg btn-outline no-animation"><?php echo e(__('Signup')); ?></a>
                                                        <?php else: ?>
                                                            <a href="<?php echo e(route('front.register.view', ['status' => 'regular', 'id' => $package->id])); ?>"
                                                                target="_self"
                                                                class="btn btn-lg btn-outline no-animation"><?php echo e(__('Purchase')); ?></a>
                                                        <?php endif; ?>


                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Bg Shape -->
            <div class="shape">
                <img class="shape-1" src="<?php echo e(asset('assets/frontend/images/shape/shape-6.png')); ?>" alt="Shape">
                <img class="shape-2" src="<?php echo e(asset('assets/frontend/images/shape/shape-7.png')); ?>" alt="Shape">
                <img class="shape-3" src="<?php echo e(asset('assets/frontend/images/shape/shape-1.png')); ?>" alt="Shape">
                <img class="shape-4" src="<?php echo e(asset('assets/frontend/images/shape/shape-4.png')); ?>" alt="Shape">
                <img class="shape-5" src="<?php echo e(asset('assets/frontend/images/shape/shape-3.png')); ?>" alt="Shape">
                <img class="shape-6" src="<?php echo e(asset('assets/frontend/images/shape/shape-9.png')); ?>" alt="Shape">
            </div>
        </section>
        <!-- Pricing End -->
    <?php endif; ?>
    <?php if($bs->featured_users_section == 1): ?>
        <!-- User Profile Start -->
        <section class="user-profile-area pb-120">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="section-title title-inline mb-50" data-aos="fade-up">
                            
                            <?php if(!empty($bs->featured_users_subtitle)): ?>
                                <h2 class="title mt-0"><?php echo e($bs->featured_users_subtitle); ?></h2>
                            <?php endif; ?>
                            <!-- Slider navigation buttons -->
                            <div class="slider-navigation">
                                <button type="button" title="Slide prev" class="slider-btn" id="user-slider-prev">
                                    <i class="fal fa-angle-left"></i>
                                </button>
                                <button type="button" title="Slide next" class="slider-btn" id="user-slider-next">
                                    <i class="fal fa-angle-right"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="swiper user-slider" data-aos="fade-up">
                            <div class="swiper-wrapper">
                                <?php $__currentLoopData = $featured_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featured_user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="swiper-slide">
                                        <div class="card text-center">
                                            <div class="icon mx-auto">
                                                <img class="lazyload"
                                                    data-src="<?php echo e(isset($featured_user->photo) ? asset('assets/front/img/user/' . $featured_user->photo) : asset('assets/admin/img/propics/blank_user.jpg')); ?>"
                                                    alt="User">
                                            </div>
                                            <div class="card-content">
                                                <h4 class="card-title">
                                                    <?php echo e($featured_user->first_name . ' ' . $featured_user->last_name); ?>

                                                </h4>
                                                <div class="social-link">
                                                    <?php $__currentLoopData = $featured_user->social_media; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <a href="<?php echo e($social->url); ?>" target="_blank"><i
                                                                class="<?php echo e($social->icon); ?>"></i></a>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </div>
                                                <div class="btn-groups justify-content-center">
                                                    <a <?php if($featured_user->status == 0): ?> title="Account deactivated" <?php endif; ?>
                                                        target="_blank"
                                                        href=" <?php if($featured_user->status == 1): ?> <?php echo e(detailsUrl($featured_user)); ?> <?php else: ?> # <?php endif; ?>"
                                                        class="btn btn-sm btn-outline <?php if($featured_user->status == 0): ?> cursor-not-allowed <?php endif; ?>">
                                                        <?php echo e(__('Website')); ?></a>
                                                    <?php if(auth()->guard()->guest()): ?>
                                                        <a href="<?php echo e(route('user.follow', ['id' => $featured_user->id])); ?>"
                                                            class="btn btn-sm btn-primary"><?php echo e(__('Follow')); ?>

                                                        </a>
                                                    <?php endif; ?>

                                                    <?php if(Auth::guard('web')->check() && Auth::guard('web')->id() != $featured_user->id): ?>
                                                        <?php if(App\Models\User\Follower::where('follower_id', Auth::id())->where('following_id', $featured_user->id)->count() > 0): ?>
                                                            <a href="<?php echo e(route('user.unfollow', Auth::guard('web')->id())); ?>"
                                                                class="btn btn-sm btn-primary"><?php echo e(__('Unfollow')); ?>

                                                            </a>
                                                        <?php else: ?>
                                                            <a href="<?php echo e(route('user.follow', ['id' => $featured_user->id])); ?>"
                                                                class="btn btn-sm btn-primary"><?php echo e(__('Follow')); ?>

                                                            </a>
                                                        <?php endif; ?>
                                                    <?php endif; ?>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Bg Shape -->
            <div class="shape">
                <img class="shape-1" src="<?php echo e(asset('assets/frontend/images/shape/shape-10.png')); ?>" alt="Shape">
                <img class="shape-2" src="<?php echo e(asset('assets/frontend/images/shape/shape-6.png')); ?>" alt="Shape">
                <img class="shape-3" src="<?php echo e(asset('assets/frontend/images/shape/shape-7.png')); ?>" alt="Shape">
                <img class="shape-4" src="<?php echo e(asset('assets/frontend/images/shape/shape-4.png')); ?>" alt="Shape">
                <img class="shape-5" src="<?php echo e(asset('assets/frontend/images/shape/shape-3.png')); ?>" alt="Shape">
                <img class="shape-6" src="<?php echo e(asset('assets/frontend/images/shape/shape-8.png')); ?>" alt="Shape">
            </div>
        </section>
        <!-- User Profile End -->
    <?php endif; ?>
    <?php if($bs->testimonial_section == 1): ?>
        <!-- Testimonial Start -->
        <section class="testimonial-area pb-80">
            <div class="container">
                <div class="row align-items-center gx-xl-5">
                    <div class="col-lg-6">
                        <div class="content mb-30" data-aos="fade-up">
                            <h2 class="title"><?php echo e($bs->testimonial_title); ?></h2>
                        </div>
                        <div class="swiper testimonial-slider mb-40" data-aos="fade-up">
                            <div class="swiper-wrapper">
                                <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="swiper-slide">
                                        <div class="slider-item bg-primary-light">
                                            <div class="ratings justify-content-between size-md">
                                                <div class="rate">
                                                    <div class="rating-icon" style="width: <?php echo e($testimonial->rating * 20); ?>%!important"></div>
                                                </div>
                                                <span class="ratings-total">
                                                    <?php echo e(number_format($testimonial->rating)); ?>

                                                    <?php if($testimonial->rating > 1): ?>
                                                    <?php echo e(__('Stars')); ?>

                                                    <?php else: ?>
                                                    <?php echo e(__('Star')); ?>

                                                    <?php endif; ?>
                                                </span>
                                            </div>
                                            <div class="quote">
                                                <p class="text mb-0">
                                                    <?php echo e($testimonial->comment); ?>

                                                </p>
                                            </div>
                                            <div class="client flex-wrap">
                                                <div class="client-info d-flex align-items-center">
                                                    <div class="client-img">
                                                        <div class="lazy-container ratio ratio-1-1">
                                                            <img class="lazyload"
                                                                src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                                                                data-src="<?php echo e($testimonial->image ? asset('assets/front/img/testimonials/' . $testimonial->image) : asset('assets/front/img/thumb-1.jpg')); ?>"
                                                                alt="Person Image">
                                                        </div>
                                                    </div>
                                                    <div class="content">
                                                        <h6 class="name"><?php echo e($testimonial->name); ?></h6>
                                                        <span class="designation"><?php echo e($testimonial->rank); ?></span>
                                                    </div>
                                                </div>
                                                <span class="icon"><i class="fas fa-quote-right"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <div class="swiper-pagination" id="testimonial-slider-pagination" data-min data-max></div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="image mb-40" data-aos="fade-left">
                            <img src="<?php echo e(!empty($bs->testimonial_image) ? asset('assets/front/img/testimonials/' . $bs->testimonial_image) : asset('assets/frontend/images/testimonial.png')); ?>"
                                alt="Image">
                        </div>
                    </div>
                </div>
            </div>
            <!-- Bg Shape -->
            <div class="shape">
                <img class="shape-1" src="<?php echo e(asset('assets/frontend/images/shape/shape-8.png')); ?>" alt="Shape">
                <img class="shape-2" src="<?php echo e(asset('assets/frontend/images/shape/shape-3.png')); ?>" alt="Shape">
                <img class="shape-3" src="<?php echo e(asset('assets/frontend/images/shape/shape-4.png')); ?>" alt="Shape">
                <img class="shape-4" src="<?php echo e(asset('assets/frontend/images/shape/shape-7.png')); ?>" alt="Shape">
                <img class="shape-5" src="<?php echo e(asset('assets/frontend/images/shape/shape-6.png')); ?>" alt="Shape">
                <img class="shape-6" src="<?php echo e(asset('assets/frontend/images/shape/shape-10.png')); ?>" alt="Shape">
            </div>
        </section>
        <!-- Testimonial End -->
    <?php endif; ?>

    <?php if($bs->news_section == 1): ?>
        <!-- Blog Start -->
        <section class="blog-area pb-90">
            <div class="container">
                <div class="section-title title-inline mb-50" data-aos="fade-up">
                    <h2 class="title"><?php echo e($bs->blog_title); ?></h2>
                    <a href="<?php echo e(route('front.blogs')); ?>" class="btn btn-lg btn-primary" title="View More"
                        target="_self"><?php echo e(__('View More')); ?></a>
                </div>
                <div class="row">
                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 col-lg-4">
                            <article class="card mb-30" data-aos="fade-up" data-aos-delay="100">
                                <div class="card-image">
                                    <a href="<?php echo e(route('front.blogdetails', ['id' => $blog->id, 'slug' => $blog->slug])); ?>"
                                        class="lazy-container ratio-16-9">
                                        <img class="lazyload lazy-image"
                                            src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                                            data-src="<?php echo e(asset('assets/front/img/blogs/' . $blog->main_image)); ?>"
                                            alt="Blog Image">
                                    </a>
                                    <ul class="info-list">
                                        <li><i
                                                class="fal fa-calendar"></i><?php echo e(\Carbon\Carbon::parse($blog->created_at)->format('F j, Y')); ?>

                                        </li>
                                        <li><a href="<?php echo e(route('front.blogs', ['category' => $blog->bcategory->id])); ?>">
                                                <i class="fal fa-tag"></i><?php echo e($blog->bcategory->name); ?></a></li>
                                    </ul>
                                </div>
                                <div class="content">
                                    <h5 class="card-title lc-2">
                                        <a
                                            href="<?php echo e(route('front.blogdetails', ['id' => $blog->id, 'slug' => $blog->slug])); ?>"><?php echo e($blog->title); ?>

                                        </a>
                                    </h5>
                                    <p class="card-text lc-2">
                                        <?php echo strlen($blog->content) > 90 ? mb_substr(strip_tags($blog->content), 0, 90, 'UTF-8') . '...' : $blog->content; ?>

                                    </p>
                                    <a href="<?php echo e(route('front.blogdetails', ['id' => $blog->id, 'slug' => $blog->slug])); ?>"
                                        class="card-btn"><?php echo e(__('Read More')); ?></a>
                                </div>
                            </article>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <!-- Bg Shape -->
            <div class="shape">
                <img class="shape-1" src="<?php echo e(asset('assets/frontend/images/shape/shape-10.png')); ?>" alt="Shape">
                <img class="shape-2" src="<?php echo e(asset('assets/frontend/images/shape/shape-6.png')); ?>" alt="Shape">
                <img class="shape-3" src="<?php echo e(asset('assets/frontend/images/shape/shape-7.png')); ?>" alt="Shape">
                <img class="shape-4" src="<?php echo e(asset('assets/frontend/images/shape/shape-4.png')); ?>" alt="Shape">
                <img class="shape-5" src="<?php echo e(asset('assets/frontend/images/shape/shape-3.png')); ?>" alt="Shape">
                <img class="shape-6" src="<?php echo e(asset('assets/frontend/images/shape/shape-8.png')); ?>" alt="Shape">
            </div>
        </section>
        <!-- Blog End -->
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/samiulalimpratik/Sites/businesso/businesso/resources/views/front/index.blade.php ENDPATH**/ ?>